@echo off
setlocal

REM Obtener el directorio actual (donde se encuentra el BAT)
set "CURR_DIR=%~dp0"

REM Limpiar el contenido de la carpeta .wwebjs_cache
if exist "%CURR_DIR%.wwebjs_cache" (
    echo Limpiando el contenido de .wwebjs_cache...
    pushd "%CURR_DIR%.wwebjs_cache"
    REM Eliminar todos los archivos (incluye subdirectorios)
    del /q /s *.* 2>nul
    REM Eliminar todos los subdirectorios
    for /d %%x in (*) do rd /s /q "%%x"
    popd
) else (
    echo La carpeta .wwebjs_cache no existe.
)

REM Limpiar el contenido de la carpeta .wwebjs_auth
if exist "%CURR_DIR%.wwebjs_auth" (
    echo Limpiando el contenido de .wwebjs_auth...
    pushd "%CURR_DIR%.wwebjs_auth"
    del /q /s *.* 2>nul
    for /d %%x in (*) do rd /s /q "%%x"
    popd
) else (
    echo La carpeta .wwebjs_auth no existe.
)

REM Limpiar la papelera de reciclaje
echo.
echo Limpiando la papelera de reciclaje...
powershell.exe -NoProfile -Command "Clear-RecycleBin -Force -ErrorAction SilentlyContinue"
if %ERRORLEVEL% EQU 0 (
    echo Papelera de reciclaje limpia.
) else (
    echo No se pudo limpiar la papelera de reciclaje.
)

echo.
echo Limpieza completada.
pause
